package com.ht.dao;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;

import rx.Observable;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.JsonArrayDocument;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ht.vo.Product;

public class KanglaEbookDAO {

	public KanglaEbookDAO() {
		super();
	}

	public JsonDocument createProduct(Bucket theBucket ,String docID, Product book) throws Exception{
		Gson gson = new GsonBuilder().create();
		book.setProductID(docID);
		JsonObject content = JsonObject.fromJson(gson.toJson(book));
		JsonDocument jdoc = JsonDocument.create(docID, content );
		JsonDocument insertDoc = theBucket.insert(jdoc);
		return insertDoc;
	}
    
	public JsonDocument createOrder(Bucket theBucket,List<Product> bookList,String userId,String deliveryInstruction) throws Exception{
		Gson gson = new GsonBuilder().create();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		SimpleDateFormat formatID = new SimpleDateFormat("yyyy-MM-ddhh:mm:ss");
		String now = format.format(Calendar.getInstance().getTime());
		String nowID = formatID.format(Calendar.getInstance().getTime());
		JsonObject content = JsonObject.empty();
		content.put("user", userId);
		content.put("documentType", "order");
		content.put("createdAt",now);
		
		content.put("items", JsonArray.from(gson.toJson(bookList)));
		content.put("instructions", deliveryInstruction);
		JsonDocument jdoc = JsonDocument.create("order::"+userId+"::"+nowID, content );
		JsonDocument insertDoc = theBucket.insert(jdoc);
		return insertDoc;
	}
	

	
	public JsonArrayDocument bindCatalogToProducts(Bucket theBucket ,JsonArrayDocument doc) throws Exception{
		JsonArrayDocument insertDoc = theBucket.insert(doc);
		return insertDoc;
	}
	public Object findDocumentByID(Bucket theBucket,String docID) throws Exception{
		
		Object result = theBucket.get(docID);
		return result;
		
	}
	public Object findArrayDocumentByID(Bucket theBucket,String docID) throws Exception{
		
		Object result = theBucket.get(docID,JsonArrayDocument.class);
		return result;
		
	}
	
   public List<Product> findMultipleProducts(final Bucket theBucket,final JsonArray prodList) throws Exception{
     	Gson gson = new GsonBuilder().create();
		List<Product> docList = Observable.from(prodList)
				   .map( d -> theBucket.get((String)d)).filter(d -> d.content() != null).
					map( doc -> (Product) gson.fromJson(doc.content().toString(), Product.class)).toList().toBlocking().single();
   		return docList;
		
	}
    
  
}
